//===========================================================================
// 
//:  
//: 28.8.2011
//===========================================================================
#include <pic.h> //  
//---------------
#include "font.h" //   
//==============================
__CONFIG (UNPROTECT & BORDIS & MCLRDIS & PWRTEN & WDTDIS & HS & IESODIS & FCMDIS);
//==============================
#define Row_1 RC0 // :    
#define Row_2 RC2
#define Row_3 RA2
#define Row_4 RC1
#define Row_5 RC7
#define Row_6 RB4
#define Row_7 RC6
#define Row_8 RB6

#define DS RC3 //  
#define SH_CP RC5
#define ST_CP RC4
//=============================
#define display_image_length 50 //  - 
//=============================
#define scroll_speed 35 // ""     (  ->  ) 
//=============================
unsigned char Display_Image_1[50]; //- ,    100 ,        50,   -    Hi-tech
bank1 unsigned char Display_Image_2[50]; //  ,   ,         
//=============================          
unsigned char Bitmask[8] = //
{
0b00000001,
0b00000010,
0b00000100,
0b00001000,
0b00010000,
0b00100000,
0b01000000,
0b10000000,
};
//================================
void Row_Enable(unsigned char row); // 
//================================
unsigned char string_length; //   USART 
unsigned char message_length; //,   
unsigned char counter; // 
unsigned char byte_counter; //    
unsigned char letter_counter, current_letter; 
bit display_processing; //   
//==============================================================
void main(void)
{
CM1CON0 = 0x00; // 
CM2CON0 = 0x00;

PIE2 = 0; //  
IOCB = 0; 

ANSEL  = 0x00; // 
ANSELH = 0x00;
ADCON0 = 0x00;

TRISA = 0; // -  
TRISB = 0;
TRISC = 0;

PORTA = 0;
PORTB = 0;
PORTC = 0;

BRGH = 0 ;
SPBRG = 255; // USART   1200 bps
TXEN = 1;
BAUDCTL = 0 ;
SYNC = 0 ;
CREN = 1;
SPEN = 1;

// Timer0:
//Prescaler=1:16; TMR0 Preset=217; Freq=8012,82051Hz; Period=124800 ns
T0CS = 0; //bit 5 TMR0 Clock Source Select bit:0=Internal Clock (CLKO) / 1=Transition on T0CKI pin
T0SE = 0; //bit 4 TMR0 Source Edge Select bit: 0=low/high / 1=high/low
PSA  = 0; //bit 3 Prescaler Assignment bit: 0=Prescaler is assigned to the Timer0
PS2  = 0; //bits 2-0  PS2:PS0: Prescaler Rate Select bits
PS1  = 1;
PS0  = 1;
TMR0 = 217; //preset for timer register

T0IE = 1; // 
RCIE = 1;
PEIE = 1;
GIE = 1;

message_length = EEPROM_READ(0xFF); //   
letter_counter = 0;

current_letter = EEPROM_READ(letter_counter); //    
byte_counter = 0;
string_length = 0;

    while(1)
    {
        if(display_processing == 1) //    
        {                           // 

        	for(counter = 0; counter != display_image_length; counter++) //  - 
            {
            Display_Image_1[counter] = Display_Image_1[counter+1];								
            }

            Display_Image_1[display_image_length-1] = Display_Image_2[0]; //  ,             

            for(counter = 0; counter != display_image_length; counter++) //  - 
            {
            Display_Image_2[counter] = Display_Image_2[counter+1];								
            }


            if(byte_counter == 5) //   
            {
            Display_Image_2[display_image_length-1] = 0; // 

            letter_counter++; // 
            	if(letter_counter == message_length) //   
              	{
              	letter_counter = 0; //  
              	}
            current_letter = EEPROM_READ(letter_counter); //    
            byte_counter = 255; //     1 
            }

            else 
            {
            Display_Image_2[display_image_length-1] = symbol[current_letter][byte_counter]; //    (     )
            }

            byte_counter++; // 
     
            display_processing = 0; //    
        }
    }
}
//===============================================================
void Row_Enable(unsigned char row) //    ,  row-   
{
if(row == 0) Row_1 = 1;   
else Row_1 = 0;

if(row == 1) Row_2 = 1;
else Row_2 = 0;

if(row == 2) Row_3 = 1;
else Row_3 = 0;

if(row == 3) Row_4 = 1;
else Row_4 = 0;

if(row == 4) Row_5 = 1;
else Row_5 = 0;

if(row == 5) Row_6 = 1;
else Row_6 = 0;

if(row == 6) Row_7 = 1;
else Row_7 = 0;

if(row == 7) Row_8 = 1;
else Row_8 = 0;
}
//==============================================================
void interrupt ISR(void)
{
unsigned char column_counter, row_counter, timer;
    if(T0IF == 1) //   
    {
       for(column_counter = display_image_length; column_counter != 0; column_counter--) //     
       {
	   DS = ~((Bitmask[row_counter] & Display_Image_2[column_counter-1])>> row_counter); //       (  2 )	
    
       SH_CP = 1; // 
       SH_CP = 0;
       }

       for(column_counter = display_image_length; column_counter != 0; column_counter--) //    
       {
	   DS = ~((Bitmask[row_counter] & Display_Image_1[column_counter-1])>> row_counter); //       (  1 ) 	
    
       SH_CP = 1; // 
       SH_CP = 0;
       }

    ST_CP = 1; //  
    ST_CP = 0;

    Row_Enable(row_counter); //  
    row_counter++; // 
    if(row_counter == 8) row_counter = 0; //  8 

    timer++; //  
    if(timer == scroll_speed) //    
    {
    display_processing = 1; //  
    timer = 0; // 
    }

    TMR0 = 217; //    
    T0IF = 0;
    }
//--------------------------------------------------
    else //  ,   - USART
    {
        if(RCREG == 92) //    
        {
        EEPROM_WRITE(string_length, 0x00); //     
        string_length++;

        EEPROM_WRITE(0xFF, string_length); //   
        message_length = string_length; // -   
        string_length = 0; //     
        return; //  
        }

        if(RCREG > 191) //             
        {
        EEPROM_WRITE(string_length, RCREG-97);
        }
        else
        {
        EEPROM_WRITE(string_length, RCREG-32);
        }
    string_length++; // 
    }
}
//================================================
__EEPROM_DATA (151, 143, 135, 129, 132, 145, 1, 0);
//================================================